%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This work by EPFL STI IBI LBNI is licensed under 
% a Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.
% Based on a work at http://lbni.epfl.ch/.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


function [  param       scaling         spl             linno       image_pos...
            ScanSize    Z_Sensitivity   Z_Magnification Scan_Rate   Defl_Sens...
            Drive_Freq  Drive_Amp       Amp_Set_Point   Z_sensor_sens Amp_sens...
            SpringConst AspectRatio     Direction       tok         remain...
            file_number channel_info    finalscaling    images      Time] = Import_file(ImageDir,BaseDir, Filename, index,S,min_spacing_stdev_user,max_spacing_stdev_user)
clear param scaling spl linno image_pos...
    ScanSize Z_Sensitivity Z_Magnification Scan_Rate Defl_Sens...
Drive_Freq Drive_Amp Amp_Set_Point Z_sensor_sens Amp_sens...
SpringConst AspectRatio Direction tok remain...
file_number channel_info finalscaling images Time;
        
        
file_name    = [ImageDir,Filename{index}];                                                                                     % Generates the filname to open for this particular iteration
[tok remain]    = strtok(Filename{index},'.');

if strcmp(remain,'.jpg') || strcmp(remain,'.jpeg') || strcmp(remain,'.tif') || strcmp(remain,'.tiff') || strcmp(remain,'.png') 
    ImageType = 'Image';
else
    fid = fopen(file_name,'r');
    line = fgets(fid);
    fclose(fid);
    if      length(strfind(line,'\*File list'))>=1
        ImageType = 'Nanoscope';
    elseif  length(strfind(line,';ANFATEC Parameterfile'))>=1
        ImageType = 'Anfatec';
    else
        ImageType = 'Unknown';
    end
end

switch ImageType
    case 'Nanoscope'
        % Read in DI Image and image propreties  This code is mostly from Jaco De Groot at University College London
        searchstring(1).label='@2:Z scale:';
        searchstring(2).label='Samps';
        searchstring(3).label='Lines:';
        searchstring(4).label='Data offset';
        searchstring(5).label='Image Data:';
        searchstring(6).label='Scan Size:';
        searchstring(7).label='@Sens. Zsens:';
        searchstring(8).label='@Z magnify:';

        searchstring(9).label='Scan Rate:';
        searchstring(10).label='@Sens. DeflSens: V';
        searchstring(11).label='@2:CantFrequency: V';
        searchstring(12).label='@2:CantDrive: V';
        searchstring(13).label='@2:TMSetAmplitude: V';
        searchstring(14).label='@Sens. ZsensSens: V';
        searchstring(15).label='@Sens. Amplitude Error: V';
        searchstring(16).label='@Sens. Amplitude: V';
        searchstring(17).label='@Sens. ForceDeflSens: V';
        searchstring(18).label='Aspect Ratio:';
        searchstring(19).label='Capture direction:';


        % openNano version 6.0
        % Last updated: 01-06-2006 by Macerano Blanco for correctly reading
        % Nanoscope 6 files
        % 
        % [images Channel_Info ]=openNano(filename)
        %
        % Reads images from a Nanoscope 6 image files. The images are stored in
        % "images" and can be displayed with imshow(images(:,:,channel_number). The
        % relevant channel number can be found in the print output fromt this subroutine
        % Basic channel information can be found in Channel_Info that for each
        % channel contains, the name, trace/retrace, unit and x and y scan size
        %
        % Example:
        % [images channel_info]=openNano('C:\Briefcase\Parchment\AFM\Dimension\CR41\CR41.000');
        % The output of this command is:
        %  Channel                                     Unit    
        %   1. Height                   Trace          um
        %   2. Deflection               Trace          V
        %
        % The following command images the trace height. The height is specified in
        % microns:
        % imshow(images(:,:,1),[]);
        % This image can be stored as a gray scale image with
        % imwrite(mat2gray(images(:,:,1)),'g:/traceheight.tif','tif');

        % This function/script is authorized for use in government and academic
        % research laboratories and non-profit institutions only. Though this
        % function has been tested prior to its posting, it may contain mistakes or
        % require improvements. In exchange for use of this free product, we 
        % request that its use and any issues that may arise be reported to us. 
        % Comments and suggestions are therefore welcome and should be sent to 
        % 
        % Jaco de Groot
        % Bone & Mineral Centre, Dept of Medicine
        % University College London
        % 5 University Street
        % The Rayne Building
        % London    WC1E 6JJ
        % Tel: 020-7679 6143
        % Mob: 07745-948245  
        % Fax: 020-7679 6219
        % Email: jacodegroot@yahoo.se
        % http://www.ucl.ac.uk/medicine/bmc/


        % Define End of file identifier
            % Opend the file given in argument and reference as
            % fid.  Also if there was an error output error
            % number and error message to screen


         fid = fopen(file_name,'r');
            [message,errnum] = ferror(fid);
            if(errnum)
                fprintf(1,'I/O Error %d \t %s',[errnum,message]);
                %   break
            end
            header_end=0; eof = 0; counter = 1; byte_location = 0;
            nstrings=size(searchstring,2);
            parcounter = ones(nstrings,1);
            paramters = struct('trace',cell(1,nstrings),'values',cell(1,nstrings),'channel',cell(1,nstrings));

            for ij=1:nstrings 
                parcounter(ij)=1; 
                parameters(ij).trace=0;
            end;

            while( and( ~eof, ~header_end ) )

            byte_location = ftell(fid); 
            line = regexprep(fgets(fid),'Zscan','Zsens');

            for ij=1:nstrings
                if strfind(lower(line),lower(searchstring(ij).label))
                    if (extract_num(line))
                        b = strfind(line, 'LSB');
                        if (b>0)
                            parameters(ij).values(parcounter(ij))=extract_num(line(b(1):end));
                        else
                            parameters(ij).values(parcounter(ij))=extract_num(line);
                        end;


                    elseif strcmp(searchstring(ij).label,'Aspect Ratio:')
                        b= strfind(line,':');
                        parameters(ij).values(parcounter(ij))=extract_num(line(b(1):b(2)-1));

                    elseif strcmp(searchstring(ij).label,'Capture direction:')
                        b= strfind(line,':');
                        parameters(ij).values(parcounter(ij)) = strcmp(line(b(1)+2),'D');

                    else
                        b= strfind(line,'"');
                        if (b>0)  
                            parameters(ij).channel(parcounter(ij)).name=line(b(1)+1:b(2)-1); 
                        else
                            if (strfind(line,'Trace')>0) 
                                parameters(ij).trace=1; 
                            end;
                        end;
                    end;
                    parcounter(ij)=parcounter(ij)+1;
                end
            end;

            if( (-1)==line )  
                eof  = 1;  
            end

            if ~isempty( strfind( line, '\*File list end' ) ) 
                header_end = 1;   
            end

            counter=counter+1;
            end

        fclose(fid);

        fid = fopen(file_name,'r');
        C = textscan(fid, '%s', 3,'delimiter','\n');
        fclose(fid);
        C = C{1};
        C = char(C(3));
        Time = C(8:end);

        param           = parameters;
        scaling         = param(1).values;                                                                                                                                                 % Scaling parameters
        spl             = param(2).values(1);                                                                                                                                                 % Samples per line
        linno           = param(3).values(1);                                                                                                                                                 % No of lines 
        image_pos       = param(4).values;                                                                                                                                                 % Data position
        if param(6).values(1) <= 100
            ScanSize    = param(6).values(2);
        else
            ScanSize    = param(6).values(1);
        end
        Z_Sensitivity   = param(7).values;                                                                                                                                                 % Data position
        Z_Magnification = param(8).values;                                                                                                                                                 % Zmagnification
        
%         if length(param(9).values) >= 5
%         Scan_Rate   = param(9).values(1);
%         else
            Scan_Rate   = param(9).values(1);
%        end
        Defl_Sens       = param(10).values;
        Drive_Freq      = param(11).values;
        Drive_Amp       = param(12).values;
        Amp_Set_Point   = param(13).values;
        Z_sensor_sens   = param(14).values;
        Amp_sens        = max([param(15).values,param(16).values]);
        if Amp_sens == 1
            Amp_sens = 1000*Amp_sens;
        end
        SpringConst     = param(17).values;
        AspectRatio     = param(18).values;
        Direction       = param(19).values;
        [tok, remain]    = strtok(Filename{index},'.');
        file_number     = str2double(remain(2:4));

        Image_Data_File = [ImageDir,BaseDir,filesep,'Imaging_Parameters.txt'];
        mkdir([ImageDir,BaseDir,filesep]);
        if  index == 1  
            fid = fopen(Image_Data_File, 'a');
            fprintf(fid, [  'File Name','\t',...
                            'File Number','\t',...
                            'File Time','\t',...
                            'Samples per Line','\t',...
                            'Lines per Image','\t',...
                            'Scan Size (nm)','\t',...
                            'Scan Rate (Hz)','\t',...
                            'Deflection Sensitivity (nm/V)','\t',...
                            'Amplitude Sensitivity (nm/V)','\t',...
                            'Drive Frequency (kHz)','\t',...
                            'Drive Amplitude (mV)','\t',...
                            'Amplitude Setpoint (mV)','\t',...
                            'Spring Constant (N/m)','\n'],...
                            'char');

            fprintf(fid, [  tok,'\t',...
                            num2str(file_number,'%0.0f'),'\t',...
                            num2str(Time,'%0.0f'),'\t',...
                            num2str(spl(1),'%0.0f'),'\t',...
                            num2str(linno,'%0.0f'),'\t',...
                            num2str(ScanSize,'%0.1f'),'\t',...
                            num2str(Scan_Rate,'%0.3f'),'\t',...
                            num2str(Defl_Sens,'%0.3f'),'\t',...
                            num2str(Amp_sens,'%0.3f'),'\t',...
                            num2str(Drive_Freq,'%0.2f'),'\t',...
                            num2str(Drive_Amp,'%0.2f'),'\t',...
                            num2str(Amp_Set_Point,'%0.2f'),'\t',...
                            num2str(SpringConst,'%0.2f'),'\n'],...
                            'char');
            fclose(fid);


        else
            fid = fopen(Image_Data_File, 'a');
            fprintf(fid, [  tok,'\t',...
                            num2str(file_number,'%0.0f'),'\t',...
                            num2str(Time,'%0.0f'),'\t',...
                            num2str(spl(1),'%0.0f'),'\t',...
                            num2str(linno,'%0.0f'),'\t',...
                            num2str(ScanSize,'%0.1f'),'\t',...
                            num2str(Scan_Rate,'%0.3f'),'\t',...
                            num2str(Defl_Sens,'%0.3f'),'\t',...
                            num2str(Amp_sens,'%0.3f'),'\t',...
                            num2str(Drive_Freq,'%0.2f'),'\t',...
                            num2str(Drive_Amp,'%0.2f'),'\t',...
                            num2str(Amp_Set_Point,'%0.2f'),'\t',...
                            num2str(SpringConst,'%0.2f'),'\n'],...
                            'char');
            fclose(fid);
        end


        L = length(image_pos);                                                                                                                                                             % Sets the number of image channels
        channel_info = struct('Trace',cell(L,1),'Name',cell(L,1),'Finalscaling',cell(L,1),'Unit',cell(L,1));
        finalscaling = zeros(L,1);
        for im=1:L                                                                                                                                                                         % Loops for the number of channels
            channel_info(im).Trace=char((param(6).trace)*'Trace  '+(1-param(6).trace)*'Retrace');                                                                                          % Determines if Channel is Trace or Retrace
            channel_info(im).Name=param(5).channel(im).name;                                                                                                                               % Name of channel 1
            channel_info(im).Finalscaling(im)=param(8).values(im)*param(1).values(im);                                                                                                     % Computes some of the scaling paramters
            mkdir([ImageDir,BaseDir,filesep,'Figure PNGS',filesep,channel_info(im).Name,filesep]);
            mkdir([ImageDir,BaseDir,filesep,'Figure PNGS',filesep,channel_info(im).Name,filesep,'hist',filesep]);
            mkdir([ImageDir,BaseDir,filesep,'Figure PNGS',filesep,channel_info(im).Name,filesep,'grey',filesep]);
            mkdir([ImageDir,BaseDir,filesep,'Figure PNGS',filesep,channel_info(im).Name,filesep,'text',filesep]);

            switch channel_info(im).Name                                                                                                                                                   % Sets Units according to recorded channel
                case 'Height'                                                                                                                                                              % If height...
                   channel_info(im).Unit='nm' ;                                                                                                                                            % Units are nm
                   channel_info(im).Finalscaling(im)=param(7).values*param(8).values(im)*param(1).values(im);                                                                              % Sets final scaling value
                   finalscaling(im)=(scaling(im)*Z_Sensitivity)/(2^16);                                                                                                                    % Sets bit scaling

                case 'Height Sensor'                                                                                                                                                              % If height...
                   channel_info(im).Unit='nm' ;                                                                                                                                            % Units are nm
                   channel_info(im).Finalscaling(im)=param(8).values(im)*param(1).values(im);                                                                                             % Sets final scaling value
                   finalscaling(im)=(scaling(im))*Z_sensor_sens/(2^16); 

                case 'Deflection'                                                                                                                                                          % If Deflection...
                    if Defl_Sens == 1
                        channel_info(im).Unit='V';
                    else
                        channel_info(im).Unit='nm';                                                                                                                                             % Units are V
                    end
                   finalscaling(im)=(scaling(im))*Defl_Sens/(2^16);                                                                                                                                  % Sets bit scaling                                                  

                case 'Deflection Error'                                                                                                                                                          % If Deflection...
                    if Defl_Sens == 1
                        channel_info(im).Unit='V';
                    else
                        channel_info(im).Unit='nm';                                                                                                                                             % Units are V
                    end
                   finalscaling(im)=(scaling(im))*Defl_Sens/(2^16);                                                                                                                                  % Sets bit scaling                                                  

                case 'Phase'                                                                                                                                                               % If Phase...
                    channel_info(im).Unit='Degree';                                                                                                                                        % Units are degrees
                    finalscaling(im)=(scaling(im))/(2^16);                                                                                                                                 % Sets bit scaling

                case 'Amplitude'                                                                                                                                                           % If Potential...
                    if Amp_sens == 1000
                        channel_info(im).Unit='mV';
                        Amp_sens = Amp_sens/1000;
                    else
                        channel_info(im).Unit='nm';                                                                                                                                             % Units are V
                        Amp_sens = Amp_sens/1000;
                    end
                    channel_info(im).Finalscaling(im)=param(8).values(im)*param(1).values(im);                                                                                             % Sets final scaling value
                    finalscaling(im)=(scaling(im)*Amp_sens)/(2^16); 

                case 'Amplitude Error'                                                                                                                                                           % If Potential...
                    if Amp_sens == 1000
                        channel_info(im).Unit='mV';
                        Amp_sens = Amp_sens/1000;
                    else
                        channel_info(im).Unit='nm';
                        Amp_sens = Amp_sens/1000;
                    end                                                                                                                                            % Units are V
                    channel_info(im).Finalscaling(im)=param(8).values(im)*param(1).values(im);                                                                                             % Sets final scaling value
                    finalscaling(im)=(scaling(im)*Amp_sens)/(2^16); 

                case 'Potential'                                                                                                                                                           % If Potential...
                    channel_info(im).Unit='V';                                                                                                                                             % Units are V
                    channel_info(im).Finalscaling(im)=param(8).values(im)*param(1).values(im);                                                                                             % Sets final scaling value
                    finalscaling(im)=(scaling(im))/(2^16);                                                                                                                                 % Sets bit scaling

                case 'Peak Force Error'                                                                                                                                                              % If height...
                   channel_info(im).Unit='nN' ;                                                                                                                                            % Units are nm
                   channel_info(im).Finalscaling(im)=param(7).values*param(8).values(im)*param(1).values(im);                                                                              % Sets final scaling value
                   finalscaling(im)=(scaling(im)*Z_Sensitivity)/(2^16); 

                case 'DMTModulus'                                                                                                                                                              % If height...
                   channel_info(im).Unit='MPa' ;                                                                                                                                            % Units are nm
                   channel_info(im).Finalscaling(im)=param(7).values*param(8).values(im)*param(1).values(im);                                                                              % Sets final scaling value
                   finalscaling(im)=(scaling(im)*Z_Sensitivity)/(2^16); 

                case 'LogDMTModulus'                                                                                                                                                              % If height...
                   channel_info(im).Unit='log(MPa)' ;                                                                                                                                            % Units are nm
                   channel_info(im).Finalscaling(im)=param(7).values*param(8).values(im)*param(1).values(im);                                                                              % Sets final scaling value
                   finalscaling(im)=(scaling(im)*Z_Sensitivity)/(2^16); 

                case 'Adhesion'                                                                                                                                                              % If height...
                   channel_info(im).Unit='nN  ' ;                                                                                                                                            % Units are nm
                   channel_info(im).Finalscaling(im)=param(7).values*param(8).values(im)*param(1).values(im);                                                                              % Sets final scaling value
                   finalscaling(im)=(scaling(im)*Z_Sensitivity)/(2^16); 

                case 'Deformation'                                                                                                                                                              % If height...
                   channel_info(im).Unit='nm' ;                                                                                                                                            % Units are nm
                   channel_info(im).Finalscaling(im)=param(7).values*param(8).values(im)*param(1).values(im);                                                                              % Sets final scaling value
                   finalscaling(im)=(scaling(im)*Z_Sensitivity)/(2^16); 

                case 'Dissipation'                                                                                                                                                              % If height...
                   channel_info(im).Unit='eV' ;                                                                                                                                            % Units are nm
                   channel_info(im).Finalscaling(im)=param(7).values*param(8).values(im)*param(1).values(im);                                                                              % Sets final scaling value
                   finalscaling(im)=(scaling(im)*Z_Sensitivity)/(2^16); 

%                 case 'Input1'                                                                                                                                                              % If height...
%                    channel_info(im).Unit='nm' ;                                                                                                                                            % Units are nm
%                    channel_info(im).Finalscaling(im)=param(7).values*param(8).values(im)*param(1).values(im);                                                                              % Sets final scaling value
%                    finalscaling(im)=(scaling(im)*Z_Sensitivity*Defl_Sens)/(2^16); 
% 
                case 'Input2'                                                                                                                                                              % If height...
                   channel_info(im).Unit='nm' ;                                                                                                                                            % Units are nm
                   channel_info(im).Finalscaling(im)=param(7).values*param(8).values(im)*param(1).values(im);                                                                              % Sets final scaling value
                   finalscaling(im)=-1*(scaling(im)*Z_Sensitivity*1000)/(2^16); 


                otherwise                                                                                                                                                                  % If unknown/other
                    channel_info(im).Unit='V';                                                                                                                                             % Units are V
                    channel_info(im).Finalscaling(im)=param(8).values(im)*param(1).values(im);                                                                                             % Sets final scaling value
                    finalscaling(im)=(scaling(im))/(2^16);                                                                                                                                 % Sets bit scaling
            end;         
        end;   



            
    fid = fopen(file_name,'r');
    
    images = zeros(linno, spl, L);
    for i = 1:L
        fseek(fid,image_pos(i),-1); 
        A               = fread(fid, [spl linno],'int16');
        images(:,:,i)   = rot90(finalscaling(i)*A);
        images(:,:,i)   = images(:,:,i)-median(reshape(images(:,:,i),size(images,1)*size(images,2),1));
    end;

    
    % Read Anfatec Files
    case 'Anfatec'
        searchstring(1).label='@2:Z scale:';            %Need to find new param
        searchstring(2).label='xPixel     :';
        searchstring(3).label='yPixel     :';
        searchstring(4).label='Data offset';            %Need to find new param 
        searchstring(5).label='Image Data:';            %Need to find new param
        searchstring(6).label='XScanRange :';
        searchstring(7).label='@Sens. Zsens:';          %Need to find new param
        searchstring(8).label='@Z magnify:';            %Need to find new param

        searchstring(9).label='Speed      :';
        searchstring(10).label='@Sens. DeflSens: V';    %Need to find new param
        searchstring(11).label='LockInFreq         :';
        searchstring(12).label='LockInAmpl         :';
        searchstring(13).label='SetPoint         :';
        searchstring(14).label='@Sens. Zsens: V';       %Need to find new param
        searchstring(15).label='FileName :'; 
        searchstring(16).label='Time :'; 
        searchstring(17).label='Caption  :'; 
        searchstring(18).label='Scale    :'; 
        searchstring(19).label='PhysUnit :'; 

        fid = fopen(file_name,'r');
        [message,errnum] = ferror(fid);
        if(errnum)
            fprintf(1,'I/O Error %d \t %s',[errnum,message]);
            %   break
        end
        header_end=0; eof = 0; counter = 1; byte_location = 0;
        nstrings=size(searchstring,2);
        parcounter = ones(nstrings,1);
        parameters = struct('values',cell(1,nstrings));

        for ij=1:nstrings 
            parcounter(ij)=1; 
        end;

        while( and( ~eof, ~header_end ) )

        byte_location = ftell(fid);  
        line = fgets(fid);

        for ij=1:nstrings
            if strfind(line,searchstring(ij).label)
                [~, remain] = strtok(line,':');
                parameters(ij).values{parcounter(ij),1} = remain;
                parcounter(ij)=parcounter(ij)+1;
            end
        end;

        if( (-1)==line )  
            eof  = 1;  
        end

        if ~isempty( strfind( line, '\*File list end' ) ) 
            header_end = 1;   
        end

        counter=counter+1;
        end
        
        fclose(fid);

        param           = parameters;
        scaling         = 0;%str2num(param(1).values{2}(2:end));                                                                                                                                                 % Scaling parameters
        spl             = str2num(param(2).values{1}(2:end));                                                                                                                                                 % Samples per line
        linno           = str2num(param(3).values{1}(2:end));                                                                                                                                                 % No of lines 
        image_pos       = 0;%str2num(param(4).values{1}(2:end));                                                                                                                                                 % Data position
        ScanSize        = str2num(param(6).values{1}(2:end))*1000;
        Z_Sensitivity   = 0;%str2num(param(7).values{1}(2:end));                                                                                                                                                 % Data position
        Z_Magnification = 0;%str2num(param(8).values{1}(2:end));                                                                                                                                                 % Zmagnification

        Scan_Rate       = str2num(strtok(param(9).values{1}(2:end),';'))/2;
        Defl_Sens       = 0;%str2num(param(10).values{1}(2:end));
        Drive_Freq      = str2num(param(11).values{1}(2:end));
        Drive_Amp       = str2num(param(12).values{1}(2:end));
        Amp_Set_Point   = str2num(param(13).values{1}(2:end))*str2num(param(12).values{1}(2:end))/100;
        Z_sensor_sens   = 0;%str2num(param(14).values{1}(2:end));
        Amp_sens        = 0;
        SpringConst     = 0;
        AspectRatio     = 1;
        Direction       = 1;
        Time            = param(16).values{1}(2:end);
        [tok, remain]    = strtok(Filename{index},'.');
        file_number     = str2double(tok(end-3:end));


        Image_Data_File = [ImageDir,BaseDir,filesep,'Imaging_Parameters.txt'];


        L = length(param(15).values);                                                                                                                                                             % Sets the number of image channels
        channel_info = struct('Trace',cell(L,1),'Name',cell(L,1),'Finalscaling',cell(L,1),'Unit',cell(L,1));
        finalscaling = zeros(L,1);


        for im=1:L                                                                                                                                                                         % Loops for the number of channels
            if  strfind(param(17).values{im},'Fwd')>0
                channel_info(im).Trace  = char('Trace');                                                                                          % Determines if Channel is Trace or Retrace
            else
                channel_info(im).Trace=char('Retrace');
            end
            if strcmp(param(17).values{im}(3:end-5),'Top')
            channel_info(im).Name               = 'Height';
            else
                
            end
            channel_info(im).Finalscaling       = str2double(param(18).values{im}(3:end-1));                                                                                                     % Computes some of the scaling paramters
            if strcmp(param(19).values{length(param(19).values)-L+im}(3:end-2),'V')
                finalscaling(im)                = 1000*str2double(param(18).values{im}(3:end-2));
                channel_info(im).Unit           = 'mV';           
            else
                finalscaling(im)                = str2double(param(18).values{im}(3:end));
                channel_info(im).Unit           = param(19).values{length(param(19).values)-L+im}(3:end-2);
            end
            mkdir(strcat(ImageDir,BaseDir,filesep,'Figure PNGS',filesep,channel_info(im).Name,filesep));
            mkdir(strcat(ImageDir,BaseDir,filesep,'Figure PNGS',filesep,channel_info(im).Name,filesep,'hist',filesep));
            mkdir(strcat(ImageDir,BaseDir,filesep,'Figure PNGS',filesep,channel_info(im).Name,filesep,'grey',filesep));
            mkdir(strcat(ImageDir,BaseDir,filesep,'Figure PNGS',filesep,channel_info(im).Name,filesep,'text',filesep));
       end;  

       images = zeros(linno, spl, L);
         for i = 1:L
            clear A
            file_name_test      = param(15).values{i}(3:end);
            fid                 = fopen(strcat(ImageDir,file_name_test),'r'); 
            A                   = fread(fid, [spl linno],'int32');
            images(:,:,i)       = flipud(rot90(finalscaling(i)*A));
            fclose(fid); 
            images(:,:,i)       = images(:,:,i)-median(reshape(images(:,:,i),size(images,1)*size(images,2),1));
         end;


        if  index == 1  
            fid = fopen(Image_Data_File, 'a');
            fprintf(fid, [  'File Name','\t',...
                            'File Number','\t',...
                            'File Time','\t',...
                            'Samples per Line','\t',...
                            'Lines per Image','\t',...
                            'Scan Size (nm)','\t',...
                            'Scan Rate (Hz)','\t',...
                            'Deflection Sensitivity (nm/V)','\t',...
                            'Amplitude Sensitivity (nm/V)','\t',...
                            'Drive Frequency (kHz)','\t',...
                            'Drive Amplitude (mV)','\t',...
                            'Amplitude Setpoint (mV)','\t',...
                            'Spring Constant (N/m)','\n'],...
                            'char');

            fprintf(fid, [  tok,'\t',...
                            num2str(file_number,'%0.0f'),'\t',...
                            num2str(Time,'%0.0f'),'\t',...
                            num2str(spl(1),'%0.0f'),'\t',...
                            num2str(linno,'%0.0f'),'\t',...
                            num2str(ScanSize,'%0.1f'),'\t',...
                            num2str(Scan_Rate,'%0.3f'),'\t',...
                            num2str(Defl_Sens,'%0.3f'),'\t',...
                            num2str(Amp_sens,'%0.3f'),'\t',...
                            num2str(Drive_Freq,'%0.2f'),'\t',...
                            num2str(Drive_Amp,'%0.2f'),'\t',...
                            num2str(Amp_Set_Point,'%0.2f'),'\t',...
                            num2str(SpringConst,'%0.2f'),'\n'],...
                            'char');
            fclose(fid);


        else
            fid = fopen(Image_Data_File, 'a');
            fprintf(fid, [  tok,'\t',...
                            num2str(file_number,'%0.0f'),'\t',...
                            num2str(Time,'%0.0f'),'\t',...
                            num2str(spl(1),'%0.0f'),'\t',...
                            num2str(linno,'%0.0f'),'\t',...
                            num2str(ScanSize,'%0.1f'),'\t',...
                            num2str(Scan_Rate,'%0.3f'),'\t',...
                            num2str(Defl_Sens,'%0.3f'),'\t',...
                            num2str(Amp_sens,'%0.3f'),'\t',...
                            num2str(Drive_Freq,'%0.2f'),'\t',...
                            num2str(Drive_Amp,'%0.2f'),'\t',...
                            num2str(Amp_Set_Point,'%0.2f'),'\t',...
                            num2str(SpringConst,'%0.2f'),'\n'],...
                            'char');
            fclose(fid);
        end

% Read Normal Image Files
    case 'Image'
        images          = imread(file_name);
        info            = imfinfo(file_name);
        
        images          = 1000*double(images)./2^(info.BitDepth-1);
        param           = []; 
        scaling         = 1;       
        spl             = size(images,1);       
        linno           = size(images,2);   
        image_pos       = 0;
        ScanSize        = 1000;   
        Z_Sensitivity   = 1;
        Z_Magnification = 1;
        Scan_Rate       = 1;
        Defl_Sens       = 1;
        Drive_Freq      = 1;
        Drive_Amp       = 1;
        Amp_Set_Point   = 1;
        Z_sensor_sens   = 1;
        Amp_sens        = 1;
        SpringConst     = 1;
        AspectRatio     = size(images,1)/size(images,2);
        Direction       = 1;   
        [tok, remain]    = strtok(Filename{index},'.');
        file_number     = index;
        
        channel_info    = struct('Trace',cell(1,1),'Name',cell(1,1),'Finalscaling',cell(1,1),'Unit',cell(1,1));
        finalscaling    = 1;                                                                                                                                                                      % Loops for the number of channels
        channel_info(1).Trace=char('Trace');                                                                                          % Determines if Channel is Trace or Retrace
        channel_info(1).Name='Height';                                                                                                                               % Name of channel 1
        channel_info(1).Finalscaling(1)=1;                                                                                                     % Computes some of the scaling paramters
        mkdir([ImageDir,BaseDir,filesep,'Figure PNGS',filesep,channel_info(1).Name,filesep]);
        mkdir([ImageDir,BaseDir,filesep,'Figure PNGS',filesep,channel_info(1).Name,filesep,'hist',filesep]);
        mkdir([ImageDir,BaseDir,filesep,'Figure PNGS',filesep,channel_info(1).Name,filesep,'grey',filesep]);
        mkdir([ImageDir,BaseDir,filesep,'Figure PNGS',filesep,channel_info(1).Name,filesep,'text',filesep]);
        
        Time            = info.FileModDate;
        
        images          = images -median(reshape(images,size(images,1)*size(images,2),1));


end
        chnl_num = 1;
        switch channel_info(1).Name                                                                                                                                                  
                case 'Height'
                    j = 1;
                case 'Height Sensor'
                    j = 2;
                case 'Deflection'
                    j = 3;
                case 'Deflection Error'
                    j = 3;
                case 'Phase'
                    j = 4;
                case 'Amplitude'
                    j = 5;
                case 'Amplitude Error'
                    j = 6;
                case 'Potential'
                    j = 7;
                case 'Peak Force Error'
                    j = 8;
                case 'DMTModulus'
                    j = 9;
                case 'LogDMTModulus'
                    j = 10;
                case 'Adhesion'
                    j = 11;
                case 'Deformation'
                    j = 12;
                case 'Dissipation'
                    j = 13;
                case 'Input1'
                    j = 14;
                case 'Input2'
                    j = 15;
        end
histogram_bins      = str2num(get(S.histogram_bins,'String'));

        min_peak_distance                          = str2double(get(S.min_peak_distance, 'string'));        
        smoothing_level                            = str2double(get(S.smoothing_level, 'string'));
        ScaleBar                                   = 1000;
        FontSize                                   = 14;  
        FontName                                   = 'Arial';                                                                                          % Font for images
        print_dpi                                  = 150;    
        amplitude_fract                            = 0.05;                                                                                             % Amplitude variability for fitting histogramed peaks to determine thresholds
        crop_fraction                              = 0.0;
        index                                      = 1;
        percent_search                             = [1 10 90 99];
        disp_percent                               = 1;
        
        min_peak_distance                          = str2double(get(S.min_peak_distance, 'string'));        
        smoothing_level                            = str2double(get(S.smoothing_level, 'string'));
        minimum_z                                  = str2double(get(S.min_z(j), 'string'));
        maximum_z                                  = str2double(get(S.max_z(j), 'string'));
        image_inside_range                         = images(:,:,chnl_num);

         
        if get(S.Calc_flatten_lim(j), 'value')     == 1
            min_spacing_stdev = 0.1*std(image_inside_range(:));
            max_spacing_stdev = 1.0*std(image_inside_range(:));
        else
            min_spacing_stdev                       = min_spacing_stdev_user;
            max_spacing_stdev                       = max_spacing_stdev_user;
        end
         channels_titles = ['Height [nm]          ';...
             'Height Sensor [nm]   ';...
             'Deflection [V]       ';...
             'Phase []            ';...
             'Amplitude [nm]       ';...
             'Amplitude error [nm] ';...
             'Potential [V]        ';...
             'Peak force error [nN]';...
             'DMTModulus [MPa]     ';...
             'logDMTMod [log(MPa)] ';...
             'Adhesion [nN]        ';...
             'Deformation [nm]     ';...
             'Dissipation [eV]     ';...
             'Input1 [nm]          ';...
             'Input2 [mV]          '];
        channel_info_Units = [  '[nm]   ';'[nm]   '; '[V]    '; '[]    '; '[nm]   ';...
                                '[nm]   '; '[V]    '; '[nN]   '; '[MPa]  ';...
                                'lg(MPa)'; '[nN]   '; '[nm]   '; '[eV]   ';...
                                '[nm]   '; '[mV]   '];
        

       
%% --- Plot a nice image in GUI --- %    


            try
                [y1_data, x_data]                        = hist(reshape(image_inside_range,size(images,1)*size(images,2),1),min(min(image_inside_range)):(max(max(image_inside_range))-min(min(image_inside_range)))/(histogram_bins-1):max(max(image_inside_range)));
            catch
                [y1_data, x_data]                        = hist(reshape(image_inside_range,size(images,1)*size(images,2),1),128);  
            end
            y2_data                                     = zeros(size(y1_data,1),1);
            x_data                                      = x_data';
            y1_data                                     = y1_data';
            y1_data                                     = smooth(y1_data,smoothing_level,'loess');
            y1_data                                     = 100*y1_data/sum(y1_data);
            for i                                       = 1:size(y1_data,1)
                y2_data(i,1)                            = sum(y1_data(1:i));
            end
        
            index_low                                   = find(y2_data >= .5,1);
            percent_low                                 = x_data(index_low);
            index_high                                  = find(y2_data >= 99.5,1);
            percent_high                                = x_data(index_high);
            

            if  max(abs([percent_low,percent_high])) >= 10
                minimum_z                                    = -10*ceil(max(abs([percent_low,percent_high]))/10);
                maximum_z                                    =  10*ceil(max(abs([percent_low,percent_high]))/10);
            elseif max(abs([percent_low,percent_high])) < 10 && max(abs([percent_low,percent_high])) >= 1 
                minimum_z                                    = -1*ceil(max(abs([percent_low,percent_high])));
                maximum_z                                    =  1*ceil(max(abs([percent_low,percent_high])));
            elseif max(abs([percent_low,percent_high])) < 1 && max(abs([percent_low,percent_high])) >= 0.1
                minimum_z                                    = -0.1*ceil(max(abs([percent_low,percent_high]))*10);
                maximum_z                                    =  0.1*ceil(max(abs([percent_low,percent_high]))*10);
            elseif max(abs([percent_low,percent_high])) < 0.1
                minimum_z                                    = -0.01*ceil(max(abs([percent_low,percent_high]))*100);
                maximum_z                                    =  0.01*ceil(max(abs([percent_low,percent_high]))*100);
            end


ScanZ                                                       = maximum_z-minimum_z;  

    axes(S.ax1)
    if AspectRatio == 1
        imshow(imresize(images(:,:,chnl_num),[max([size(images(:,:,chnl_num),1),size(images(:,:,chnl_num),2)]),max([size(images(:,:,chnl_num),1),size(images(:,:,chnl_num),2)])]),[minimum_z,maximum_z],'Parent',S.ax1);                                      % Generates a new Figure with the name of the correct channel,  Resizes the image to a square the size of the largest dimension.  This is useful when using nonsquare pixels.  Sets the display range from the min to the max      
    else
        imshow(imresize(images(:,:,chnl_num),[max([size(images(:,:,chnl_num),1),size(images(:,:,chnl_num),2)])./AspectRatio(1),max([size(images(:,:,chnl_num),1),size(images(:,:,chnl_num),2)])]),[minimum_z,maximum_z],'Parent',S.ax1);                                      % Generates a new Figure with the name of the correct channel,  Resizes the image to a square the size of the largest dimension.  This is useful when using nonsquare pixels.  Sets the display range from the min to the max      
    end
        color_string    = get(S.ColorBarSelect, 'string');
        color_value     = get(S.ColorBarSelect, 'value');
        switch color_string{color_value}                                                                                                                                                   
            case 'Autumn'                                                                                                                                                        
                colormap(autumn);
            case 'Bone'                                                                                                                                                        
                colormap(bone);
            case 'ColorCube'                                                                                                                                                        
                colormap(colorcube);
            case 'Cool'                                                                                                                                                        
                colormap(cool);
            case 'Copper'                                                                                                                                                        
                colormap(copper);
            case 'Flag'                                                                                                                                                        
                colormap(flag);
            case 'Gray'                                                                                                                                                        
                colormap(gray);
            case 'Hot'                                                                                                                                                        
                colormap(hot);
            case 'HSV'                                                                                                                                                        
                colormap(hsv);
            case 'Jet'                                                                                                                                                        
                colormap(jet);
            case 'Lines'                                                                                                                                                        
                colormap(lines);
            case 'Pink'                                                                                                                                                        
                colormap(pink);
            case 'Prism'                                                                                                                                                        
                colormap(prism);
            case 'Spring'                                                                                                                                                        
                colormap(spring);
            case 'Summer'                                                                                                                                                        
                colormap(summer);
            case 'Winter'                                                                                                                                                        
                colormap(winter);
            case 'Sky'
                load('Sky','mycmap_sky') 
                colormap(mycmap_sky);
            case 'NanoBrown'
                load('NanoBrown','mycmap_nanobrown') 
                colormap(mycmap_nanobrown);
        end
                                                                                                                                                            % Sets the colormap 

            hcb= colorbar('peer',S.ax1,'YTick',minimum_z:ScanZ/10:maximum_z,...
                          'YTickLabel',{            [num2str(minimum_z+0*ScanZ/10,'%0.2f'),' ', channel_info_Units(j,:)],...                                                                    % Inserts a color bar.  Sets the 1st tick with approriate labels
                                                    [num2str(minimum_z+1*ScanZ/10,'%0.2f'),' ', channel_info_Units(j,:)],...                                                                    % Sets the 2nd tick with approriate labels
                                                    [num2str(minimum_z+2*ScanZ/10,'%0.2f'),' ', channel_info_Units(j,:)],...                                                                    % Sets the 3rd tick with approriate labels
                                                    [num2str(minimum_z+3*ScanZ/10,'%0.2f'),' ', channel_info_Units(j,:)],...                                                                    % Sets the 4th tick with approriate labels
                                                    [num2str(minimum_z+4*ScanZ/10,'%0.2f'),' ', channel_info_Units(j,:)],...                                                                    % Sets the 5th tick with approriate labels
                                                    [num2str(minimum_z+5*ScanZ/10,'%0.2f'),' ', channel_info_Units(j,:)],...                                                                    % Sets the 6th tick with approriate labels
                                                    [num2str(minimum_z+6*ScanZ/10,'%0.2f'),' ', channel_info_Units(j,:)],...                                                                    % Sets the 7th tick with approriate labels
                                                    [num2str(minimum_z+7*ScanZ/10,'%0.2f'),' ', channel_info_Units(j,:)],... 
                                                    [num2str(minimum_z+8*ScanZ/10,'%0.2f'),' ', channel_info_Units(j,:)],...  
                                                    [num2str(minimum_z+9*ScanZ/10,'%0.2f'),' ', channel_info_Units(j,:)],...                                                                    % Sets the 8th tick with approriate labels
                                                    [num2str(minimum_z+10*ScanZ/10,'%0.2f'),' ', channel_info_Units(j,:)]},...                                                                  % Sets the 9th tick with approriate labels
                                                    'FontSize', FontSize, 'FontName', FontName);                                                                                            % Sets the font and size for the color bar
            set(hcb,'YTickMode','manual','FontSize', FontSize, 'FontName', FontName);                                                                                                       % Apply the font to the colorbar

disp_scale_bar      = get(S.disp_scale_bar, 'value');
if disp_scale_bar == 1
        %This plots the integral scale bar.  It works...  It's not all my code.
        DistFactor                                  = 0.05;                                                                                                                                 % Scalebar height
        Length                                      = ScaleBar;                                                                                                                             % User set scalebar length
        Pos                                         = [0.5*max(size(images(:,:,chnl_num))),0.95*max(size(images(:,:,chnl_num)))];                                                                         % positions scale bar
        Scale                                       = ScanSize/(size(images,2)*(1+crop_fraction));                                                                                                              % Image scale
        UnitsName                                   = ' nm';                                                                                                                                % Units for the scale bar
        NextPlot                                    = get(gca,'NextPlot');                                                                                                              
        
        hold on;

        XLim                                        = get(gca,'XLim');
        YLim                                        = get(gca,'YLim');
        Xdiff                                       = abs(diff(XLim));
        Ydiff                                       = abs(diff(YLim));

        LineX                                       = Pos(1) + 0.5.*Length./Scale.*[-1;+1];
        LineY                                       = Pos(2).*[+1;+1];
        DistXdir                                    = 0;
        DistYdir                                    = -1;


        %--- plot line ---
        plot(LineX,LineY,'w-','LineWidth',2);


        %--- plot text ---
        DistX                                       = DistXdir.*DistFactor.*Xdiff;
        DistY                                       = DistYdir.*DistFactor.*Ydiff;

        Htext                                       = text(Pos(1)+DistX,Pos(2)+DistY,sprintf('%5.1f %s',Length,UnitsName));
        set(Htext,'HorizontalAlignment','center','Color', 'w', 'FontSize', FontSize, 'FontName', FontName);
        set(gca,'XLim',XLim);
        set(gca,'YLim',YLim);
        set(gca,'NextPlot',NextPlot);
        set(gca, 'XTickMode', 'manual')
else
end
        hold off;      
%% ---Plot a nice histogram and cdf in GUI ---%
            axes(S.ax2)
            image_inside_range                                   = images(:,:,chnl_num);
            image_inside_range((images(:,:,chnl_num) < minimum_z))      = NaN;                                                                                                              
            image_inside_range((images(:,:,chnl_num) > maximum_z))      = NaN;
            
 
            try
                [y1_data, x_data]                            = hist(reshape(image_inside_range(:,:),size(images,1)*size(images,2),1),minimum_z:(maximum_z-minimum_z)/(histogram_bins-1):maximum_z);
            catch
                [y1_data, x_data]                            = hist(reshape(image_inside_range(:,:),size(images,1)*size(images,2),1),128);
                minimum_z = min(x_data);
                maximum_z = max(x_data);
            end
            y2_data                                         = zeros(size(y1_data,1),1);
            x_data                                          = x_data';
            y1_data                                         = y1_data';
            y1_data                                         = smooth(y1_data,smoothing_level,'loess');
            y1_data                                         = 100*y1_data/sum(y1_data);
            for i                                           = 1:size(y1_data,1)
                y2_data(i,1)                                = sum(y1_data(1:i));
            end

                [AX,H1,H2]                                  = plotyy(S.ax2,x_data,y1_data,x_data,y2_data,'plot');
                set(AX(1),'YColor','k');
                set(AX(2),'YColor','r');
                axis auto;
                
                hold on;

                set(AX(1),'YLim',[-0.002*ceil(max(y1_data)) 1.002*ceil(max(y1_data))],'YTick',0:ceil(max(y1_data))/10:ceil(max(y1_data)),'YTickLabel',0:ceil(max(y1_data))/10:ceil(max(y1_data)))
                set(AX(2),'YLim',[-0.2 100.2],'YTick',0:10:100,'YTickLabel',0:10:100) 
                    axis_lim = [minimum_z,maximum_z];
                    set(AX(1),'XLim',axis_lim(1:2),'XTick',axis_lim(1):(axis_lim(2)-axis_lim(1))/10:axis_lim(2),'XTickLabel',axis_lim(1):(axis_lim(2)-axis_lim(1))/10:axis_lim(2));
                    set(AX(2),'XLim',axis_lim(1:2),'XTick',axis_lim(1):(axis_lim(2)-axis_lim(1))/10:axis_lim(2),'XTickLabel',axis_lim(1):(axis_lim(2)-axis_lim(1))/10:axis_lim(2));

                set(AX(1),'yticklabel',sprintf('%0.1f |',get(AX(1),'ytick')'));
                set(AX(2),'yticklabel',sprintf('%0.0f |',get(AX(2),'ytick')'));
                set(get(AX(1),'Ylabel'),'String','% Area','FontSize', FontSize, 'FontName', FontName,'Color','k');
                set(get(AX(2),'Ylabel'),'String','% Below Given Value','FontSize', FontSize, 'FontName', FontName,'Color','r');

                set(H1,'Color','k','LineWidth',2);
                set(H2,'Color','r','LineWidth',2);

                xlabel(channels_titles(j,:),'FontSize', FontSize, 'FontName', FontName );
                %title([channel_info(j).Name,'(',num2str(j),')',' ',num2str(file_number)],'FontSize', FontSize*1.5, 'FontName', FontName ); 
                set(AX(1),'FontSize', FontSize, 'FontName', FontName);
                set(AX(2),'FontSize', FontSize, 'FontName', FontName);

                if disp_percent == 1
                    percent_val                                     = zeros(length(percent_search),1);
                    text_disp                                       =  cell(length(percent_search),1);
                    for i                                           = 1:length(percent_search)
                        index_height                                = find(y2_data >= percent_search(i),1);
                        percent_val(i)                              = x_data(index_height);
                        text_disp{i,1}                              = [num2str(percent_search(i)),'% below ',num2str(percent_val(i),'%02.2f'),' ',channel_info_Units(j,:)];
                    end
                    x_range                                         = get(AX(1),'XLim'); 
                    y_range                                         = get(AX(1),'YLim');
                    text(x_range(2) -.02*(x_range(2)-x_range(1)),y_range(2)-.02*(y_range(2)-y_range(1)),text_disp,'FontSize', 0.75*FontSize, 'FontName', FontName,'VerticalAlignment','top','HorizontalAlignment','right' );
                else
                end


            hold off; 
 

end

